/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rados;

import com.ceph.rados.Library;
import com.ceph.rados.exceptions.RadosException;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.nio.ByteBuffer;

public class ReadOp {
    private final Pointer ioctxPtr;
    private final Pointer readOpPtr;

    ReadOp(Pointer ioctx_p, Pointer readop_p) {
        this.ioctxPtr = ioctx_p;
        this.readOpPtr = readop_p;
    }

    Pointer getPointer() {
        return this.readOpPtr;
    }

    public ReadResult queueRead(long offset, long len) throws RadosException {
        ReadResult r = new ReadResult(len);
        Library.rados.rados_read_op_read(this.readOpPtr, offset, len, r.getBuffer(), r.bytesread, r.rval);
        return r;
    }

    public int operate(String oid, int flags) {
        return Library.rados.rados_read_op_operate(this.readOpPtr, this.ioctxPtr, oid, flags);
    }

    public static class ReadResult {
        private final ByteBuffer buf;
        final LongByReference bytesread;
        final IntByReference rval;

        ReadResult(long buflen) throws RadosException {
            if (buflen > Integer.MAX_VALUE) {
                throw new RadosException("rados_read_op_read Java byte[] buffer cannot be longer than 2147483647");
            }
            this.buf = ByteBuffer.allocateDirect((int)buflen);
            this.bytesread = new LongByReference();
            this.rval = new IntByReference();
        }

        public ByteBuffer getBuffer() {
            return this.buf;
        }

        public long getBytesRead() {
            return this.bytesread.getValue();
        }

        public int getRVal() {
            return this.rval.getValue();
        }
    }
}

