/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rados;

import com.ceph.rados.Library;
import com.ceph.rados.exceptions.RadosException;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.util.Arrays;

public class ListCtx {
    Pointer list;
    String[] ids;
    int size;
    int limit;

    protected ListCtx(int limit, Pointer list) {
        this.limit = limit;
        this.ids = new String[limit];
        this.list = list;
        this.size = 0;
    }

    public int nextObjects() throws RadosException {
        int i;
        if (this.list == null) {
            return 0;
        }
        Memory entry = new Memory((long)Pointer.SIZE);
        for (i = 0; i < this.limit && Library.rados.rados_objects_list_next(this.list.getPointer(0L), (Pointer)entry, null) == 0; ++i) {
            this.ids[i] = entry.getPointer(0L).getString(0L);
        }
        if (i < this.limit) {
            Library.rados.rados_objects_list_close(this.list.getPointer(0L));
            this.list = null;
        }
        this.size = i;
        return this.size;
    }

    public int nextObjects(long skip) throws RadosException {
        int i;
        if (this.list == null) {
            return 0;
        }
        Memory entry = new Memory((long)Pointer.SIZE);
        for (long j = 0L; j < skip && Library.rados.rados_objects_list_next(this.list.getPointer(0L), (Pointer)entry, null) == 0; ++j) {
        }
        for (i = 0; i < this.limit && Library.rados.rados_objects_list_next(this.list.getPointer(0L), (Pointer)entry, null) == 0; ++i) {
            this.ids[i] = entry.getPointer(0L).getString(0L);
        }
        if (i < this.limit) {
            Library.rados.rados_objects_list_close(this.list.getPointer(0L));
            this.list = null;
        }
        this.size = i;
        return this.size;
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.size;
    }

    public String[] getObjects() {
        return Arrays.copyOf(this.ids, this.size);
    }

    public void close() {
        if (this.list != null) {
            Library.rados.rados_objects_list_close(this.list.getPointer(0L));
            this.list = null;
        }
    }
}

