/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rados;

import com.ceph.rados.IoCTX;
import com.ceph.rados.Library;
import com.ceph.rados.RadosException;
import com.ceph.rados.jna.RadosClusterInfo;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;

public class Rados {
    protected Pointer clusterPtr;
    private boolean connected;

    public Rados(String string) {
        PointerByReference pointerByReference = new PointerByReference();
        Library.rados.rados_create(pointerByReference, string);
        this.clusterPtr = pointerByReference.getValue();
    }

    public Rados(String string, String string2, long l) {
        PointerByReference pointerByReference = new PointerByReference();
        Library.rados.rados_create2(pointerByReference, string, string2, l);
        this.clusterPtr = pointerByReference.getValue();
    }

    public Rados() {
        this(null);
    }

    private void verifyConnected(boolean bl) throws RadosException {
        if (bl && !this.connected) {
            throw new RadosException("This method should not be called in a disconnected state.");
        }
        if (!bl && this.connected) {
            throw new RadosException("This method should not be called in a connected state.");
        }
    }

    public void confReadFile(File file) throws RadosException {
        this.verifyConnected(false);
        int n = Library.rados.rados_conf_read_file(this.clusterPtr, file.getAbsolutePath());
        if (n < 0) {
            throw new RadosException("Failed reading configuration file " + file.getAbsolutePath(), n);
        }
    }

    public void confSet(String string, String string2) throws RadosException {
        this.verifyConnected(false);
        int n = Library.rados.rados_conf_set(this.clusterPtr, string, string2);
        if (n < 0) {
            throw new RadosException("Could not set configuration option " + string, n);
        }
    }

    public String confGet(String string) throws RadosException {
        byte[] byArray = new byte[256];
        int n = Library.rados.rados_conf_get(this.clusterPtr, string, byArray, byArray.length);
        if (n < 0) {
            throw new RadosException("Unable to retrieve the value of configuration option " + string, n);
        }
        return Native.toString((byte[])byArray);
    }

    public void connect() throws RadosException {
        int n = Library.rados.rados_connect(this.clusterPtr);
        if (n < 0) {
            throw new RadosException("The connection to the Ceph cluster failed", n);
        }
        this.connected = true;
    }

    public String clusterFsid() throws RadosException {
        this.verifyConnected(true);
        byte[] byArray = new byte[256];
        int n = Library.rados.rados_cluster_fsid(this.clusterPtr, byArray, byArray.length);
        if (n < 0) {
            throw new RadosException("Unable to retrieve the cluster's fsid", n);
        }
        return Native.toString((byte[])byArray);
    }

    public RadosClusterInfo clusterStat() throws RadosException {
        this.verifyConnected(true);
        RadosClusterInfo radosClusterInfo = new RadosClusterInfo();
        int n = Library.rados.rados_cluster_stat(this.clusterPtr, radosClusterInfo);
        return radosClusterInfo;
    }

    public void poolCreate(String string) throws RadosException {
        this.verifyConnected(true);
        int n = Library.rados.rados_pool_create(this.clusterPtr, string);
        if (n < 0) {
            throw new RadosException("Failed to create pool " + string, n);
        }
    }

    public void poolCreate(String string, long l) throws RadosException {
        this.verifyConnected(true);
        int n = Library.rados.rados_pool_create_with_auid(this.clusterPtr, string, l);
        if (n < 0) {
            throw new RadosException("Failed to create pool " + string + " with auid " + l, n);
        }
    }

    public void poolCreate(String string, long l, long l2) throws RadosException {
        this.verifyConnected(true);
        int n = Library.rados.rados_pool_create_with_all(this.clusterPtr, string, l, l2);
        if (n < 0) {
            throw new RadosException("Failed to create pool " + string + " with auid " + l + " and crushrule " + l2, n);
        }
    }

    public void poolDelete(String string) throws RadosException {
        this.verifyConnected(true);
        int n = Library.rados.rados_pool_delete(this.clusterPtr, string);
        if (n < 0) {
            throw new RadosException("Failed to delete pool " + string, n);
        }
    }

    protected void finalize() throws Throwable {
        Library.rados.rados_shutdown(this.clusterPtr);
        super.finalize();
    }

    public String[] poolList() throws RadosException {
        this.verifyConnected(true);
        byte[] byArray = new byte[256];
        int n = Library.rados.rados_pool_list(this.clusterPtr, byArray, byArray.length);
        byte[] byArray2 = new byte[n];
        int n2 = Library.rados.rados_pool_list(this.clusterPtr, byArray2, byArray2.length);
        if (n2 < 0) {
            throw new RadosException("Couldn't list all pools", n2);
        }
        return new String(byArray2).split("\u0000");
    }

    public long poolLookup(String string) throws RadosException {
        long l = Library.rados.rados_pool_lookup(this.clusterPtr, string);
        if (l < 0L) {
            throw new RadosException("Couldn't fetch the ID of the pool. Does it exist?", (int)l);
        }
        return l;
    }

    public String poolReverseLookup(long l) throws RadosException {
        byte[] byArray = new byte[512];
        int n = Library.rados.rados_pool_reverse_lookup(this.clusterPtr, l, byArray, byArray.length);
        if (n < 0) {
            throw new RadosException("Couldn't fetch the name of the pool. Does it exist?", n);
        }
        return new String(byArray).trim();
    }

    public IoCTX ioCtxCreate(String string) throws RadosException {
        Memory memory = new Memory((long)Pointer.SIZE);
        int n = Library.rados.rados_ioctx_create(this.clusterPtr, string, (Pointer)memory);
        if (n < 0) {
            throw new RadosException("Failed to create the IoCTX for " + string, n);
        }
        return new IoCTX((Pointer)memory);
    }

    public void ioCtxDestroy(IoCTX ioCTX) {
        Library.rados.rados_ioctx_destroy(ioCTX.getPointer());
    }

    public long getInstanceId() throws RadosException {
        this.verifyConnected(true);
        return Library.rados.rados_get_instance_id(this.clusterPtr);
    }

    public static int[] getVersion() {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        IntByReference intByReference3 = new IntByReference();
        Library.rados.rados_version(intByReference, intByReference2, intByReference3);
        int[] nArray = new int[]{intByReference.getValue(), intByReference2.getValue(), intByReference3.getValue()};
        return nArray;
    }
}

