/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rbd;

import com.ceph.rbd.jna.Rbd;
import com.sun.jna.Pointer;
import java.io.UnsupportedEncodingException;

final class Library {
    static final Rbd rbd = Rbd.INSTANCE;

    private Library() {
    }

    static void free(Pointer pointer) {
        Pointer.nativeValue((Pointer)pointer, (long)0L);
    }

    static String getString(Pointer pointer) {
        long l = pointer.indexOf(0L, (byte)0);
        assert (l != -1L) : "C-Strings must be \\0 terminated.";
        byte[] byArray = pointer.getByteArray(0L, (int)l);
        try {
            return new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Rbd problem: UTF-8 decoding error.", unsupportedEncodingException);
        }
    }

    static String[] toStringArray(Pointer[] pointerArray) {
        return Library.toStringArray(pointerArray, pointerArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] toStringArray(Pointer[] pointerArray, int n) {
        String[] stringArray;
        try {
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = Library.getString(pointerArray[i]);
            }
            stringArray = stringArray2;
        }
        catch (Throwable throwable) {
            for (int i = 0; i < n; ++i) {
                Library.free(pointerArray[i]);
                pointerArray[i] = null;
            }
            throw throwable;
        }
        for (int i = 0; i < n; ++i) {
            Library.free(pointerArray[i]);
            pointerArray[i] = null;
        }
        return stringArray;
    }
}

