/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rbd;

import com.ceph.rados.IoCTX;
import com.ceph.rbd.Library;
import com.ceph.rbd.RbdException;
import com.ceph.rbd.RbdImage;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

public class Rbd {
    Pointer io;

    public static int[] getVersion() {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        IntByReference intByReference3 = new IntByReference();
        Library.rbd.rbd_version(intByReference, intByReference2, intByReference3);
        int[] nArray = new int[]{intByReference.getValue(), intByReference2.getValue(), intByReference3.getValue()};
        return nArray;
    }

    public Rbd(IoCTX ioCTX) {
        this.io = ioCTX.getPointer();
    }

    public void create(String string, long l, int n) throws RbdException {
        IntByReference intByReference = new IntByReference(n);
        int n2 = Library.rbd.rbd_create(this.io, string, l, intByReference);
        if (n2 < 0) {
            throw new RbdException("Failed to create image " + string, n2);
        }
    }

    public void create(String string, long l) throws RbdException {
        this.create(string, l, 0);
    }

    public void create(String string, long l, long l2, int n) throws RbdException {
        IntByReference intByReference = new IntByReference(n);
        int n2 = Library.rbd.rbd_create2(this.io, string, l, l2, intByReference);
        if (n2 < 0) {
            throw new RbdException("Failed to create image " + string, n2);
        }
    }

    public void create(String string, long l, long l2) throws RbdException {
        this.create(string, l, l2, 0);
    }

    public void create(String string, long l, long l2, int n, long l3, long l4) throws RbdException {
        IntByReference intByReference = new IntByReference(n);
        int n2 = Library.rbd.rbd_create3(this.io, string, l, l2, intByReference, l3, l4);
        if (n2 < 0) {
            throw new RbdException("Failed to create image " + string, n2);
        }
    }

    public void remove(String string) throws RbdException {
        int n = Library.rbd.rbd_remove(this.io, string);
        if (n < 0) {
            throw new RbdException("Failed to remove image " + string, n);
        }
    }

    public void rename(String string, String string2) throws RbdException {
        int n = Library.rbd.rbd_rename(this.io, string, string2);
        if (n < 0) {
            throw new RbdException("Failed to rename image " + string + " to " + string2, n);
        }
    }

    public String[] list() throws RbdException {
        byte[] byArray;
        int n;
        IntByReference intByReference = new IntByReference(1024);
        while ((n = Library.rbd.rbd_list(this.io, byArray = new byte[intByReference.getValue()], intByReference)) < 0) {
            if (n == -34) continue;
            throw new RbdException("Failed listing the RBD images", n);
        }
        return Native.toString((byte[])byArray).split("\u0000");
    }

    public RbdImage open(String string) throws RbdException {
        Memory memory = new Memory((long)Pointer.SIZE);
        int n = Library.rbd.rbd_open(this.io, string, (Pointer)memory, null);
        if (n < 0) {
            throw new RbdException("Failed to open image " + string, n);
        }
        return new RbdImage((Pointer)memory, string);
    }

    public void close(RbdImage rbdImage) throws RbdException {
        int n = Library.rbd.rbd_close(rbdImage.getPointer());
        if (n < 0) {
            throw new RbdException("Failed to close image", n);
        }
    }

    public void clone(String string, String string2, IoCTX ioCTX, String string3, long l, int n, long l2, long l3) throws RbdException {
        IntByReference intByReference = new IntByReference(n);
        int n2 = Library.rbd.rbd_clone2(this.io, string, string2, ioCTX.getPointer(), string3, l, intByReference, l2, l3);
        if (n2 < 0) {
            throw new RbdException("Failed to clone image " + string + "@" + string2 + " to " + string3, n2);
        }
    }

    public void clone(String string, String string2, IoCTX ioCTX, String string3, long l, int n) throws RbdException {
        IntByReference intByReference = new IntByReference(n);
        int n2 = Library.rbd.rbd_clone(this.io, string, string2, ioCTX.getPointer(), string3, l, intByReference);
        if (n2 < 0) {
            throw new RbdException("Failed to clone image " + string + "@" + string2 + " to " + string3, n2);
        }
    }

    public void copy(RbdImage rbdImage, RbdImage rbdImage2) throws RbdException {
        int n = Library.rbd.rbd_copy2(rbdImage.getPointer(), rbdImage2.getPointer());
        if (n < 0) {
            throw new RbdException("Failed to copy image " + rbdImage.getName() + " to " + rbdImage2.getName(), n);
        }
    }
}

