/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.fs;

import com.ceph.fs.CephMount;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class CephNativeLoader {
    private static String LIB_BASE_NAME = "cephfs_jni";
    private static String LIB_SUFFIX = ".so";
    private static String LIB_JAR_PATH_PREFIX = "/com/ceph/native/";
    private static String TEMP_FILE_PREFIX = "libcephfs_jni";
    private static String LIBPATH_PROPERTY = "cephfs.jni.library";
    private static String LIBPATH_ENV = "CEPHFS_JNI_LIBRARY";
    private static boolean loaded = false;

    CephNativeLoader() {
    }

    private static String getSystemPrefix() {
        String string = System.getProperty("os.arch");
        if (string.equals("i386")) {
            string = "x86";
        } else if (string.equals("x86_64") || string.equals("amd64")) {
            string = "x86-64";
        }
        String string2 = "linux";
        return string2 + "-" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibraryFromJar(String string) throws IOException {
        String string2 = LIB_JAR_PATH_PREFIX + string + "/" + LIB_BASE_NAME + LIB_SUFFIX;
        InputStream inputStream = CephNativeLoader.class.getResourceAsStream(string2);
        if (inputStream == null) {
            throw new FileNotFoundException(string2);
        }
        File file = File.createTempFile(TEMP_FILE_PREFIX, null);
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
        }
        finally {
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        System.load(file.getAbsolutePath());
    }

    static void checkLoaded() {
        assert (loaded);
    }

    static {
        if (!loaded) {
            String string = System.getProperty(LIBPATH_PROPERTY);
            if (string == null) {
                string = System.getenv(LIBPATH_ENV);
            }
            if (string != null) {
                System.load(string);
            } else {
                try {
                    System.loadLibrary(LIB_BASE_NAME);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    String string2 = CephNativeLoader.getSystemPrefix();
                    try {
                        CephNativeLoader.loadLibraryFromJar(string2);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        throw new RuntimeException("Error loading CephFS JNI library (" + string2 + ")");
                    }
                }
            }
            CephMount.native_initialize();
            loaded = true;
        }
    }
}

