/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.fs;

import com.ceph.crush.Bucket;
import com.ceph.fs.CephFileExtent;
import com.ceph.fs.CephNativeLoader;
import com.ceph.fs.CephNotDirectoryException;
import com.ceph.fs.CephPoolException;
import com.ceph.fs.CephStat;
import com.ceph.fs.CephStatVFS;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CephMount {
    private long instance_ptr;
    public static final int O_RDONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_APPEND = 4;
    public static final int O_CREAT = 8;
    public static final int O_TRUNC = 16;
    public static final int O_EXCL = 32;
    public static final int O_WRONLY = 64;
    public static final int SEEK_SET = 1;
    public static final int SEEK_CUR = 2;
    public static final int SEEK_END = 3;
    public static final int SETATTR_MODE = 1;
    public static final int SETATTR_UID = 2;
    public static final int SETATTR_GID = 4;
    public static final int SETATTR_MTIME = 8;
    public static final int SETATTR_ATIME = 16;
    public static final int XATTR_CREATE = 1;
    public static final int XATTR_REPLACE = 2;
    public static final int XATTR_NONE = 3;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final Lock rlock = this.rwlock.readLock();
    private final Lock wlock = this.rwlock.writeLock();
    private boolean initialized = false;

    static native void native_initialize();

    protected void finalize() throws Throwable {
        if (this.initialized) {
            try {
                this.unmount();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                CephMount.native_ceph_release(this.instance_ptr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public CephMount(String string) {
        CephMount.native_ceph_create(this, string);
        this.initialized = true;
    }

    private static native int native_ceph_create(CephMount var0, String var1);

    public CephMount() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mount(String string) {
        this.wlock.lock();
        try {
            CephMount.native_ceph_mount(this.instance_ptr, string);
        }
        finally {
            this.wlock.unlock();
        }
    }

    private static native int native_ceph_mount(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmount() {
        this.wlock.lock();
        try {
            CephMount.native_ceph_unmount(this.instance_ptr);
        }
        finally {
            this.wlock.unlock();
        }
    }

    private static native int native_ceph_unmount(long var0);

    private static native int native_ceph_release(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conf_read_file(String string) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_conf_read_file(this.instance_ptr, string);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_conf_read_file(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conf_set(String string, String string2) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_conf_set(this.instance_ptr, string, string2);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_conf_set(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String conf_get(String string) {
        this.rlock.lock();
        try {
            String string2 = CephMount.native_ceph_conf_get(this.instance_ptr, string);
            return string2;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String native_ceph_conf_get(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statfs(String string, CephStatVFS cephStatVFS) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_statfs(this.instance_ptr, string, cephStatVFS);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_statfs(long var0, String var2, CephStatVFS var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getcwd() {
        this.rlock.lock();
        try {
            String string = CephMount.native_ceph_getcwd(this.instance_ptr);
            return string;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String native_ceph_getcwd(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chdir(String string) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_chdir(this.instance_ptr, string);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_chdir(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listdir(String string) throws FileNotFoundException {
        this.rlock.lock();
        try {
            String[] stringArray = CephMount.native_ceph_listdir(this.instance_ptr, string);
            return stringArray;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String[] native_ceph_listdir(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void link(String string, String string2) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_link(this.instance_ptr, string, string2);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_link(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink(String string) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_unlink(this.instance_ptr, string);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_unlink(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String string, String string2) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_rename(this.instance_ptr, string, string2);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_rename(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdir(String string, int n) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_mkdir(this.instance_ptr, string, n);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_mkdir(long var0, String var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdirs(String string, int n) throws IOException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_mkdirs(this.instance_ptr, string, n);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_mkdirs(long var0, String var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmdir(String string) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_rmdir(this.instance_ptr, string);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_rmdir(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readlink(String string) throws FileNotFoundException {
        this.rlock.lock();
        try {
            String string2 = CephMount.native_ceph_readlink(this.instance_ptr, string);
            return string2;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String native_ceph_readlink(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void symlink(String string, String string2) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_symlink(this.instance_ptr, string, string2);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_symlink(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stat(String string, CephStat cephStat) throws FileNotFoundException, CephNotDirectoryException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_stat(this.instance_ptr, string, cephStat);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_stat(long var0, String var2, CephStat var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lstat(String string, CephStat cephStat) throws FileNotFoundException, CephNotDirectoryException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_lstat(this.instance_ptr, string, cephStat);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_lstat(long var0, String var2, CephStat var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setattr(String string, CephStat cephStat, int n) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_setattr(this.instance_ptr, string, cephStat, n);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_setattr(long var0, String var2, CephStat var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chmod(String string, int n) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_chmod(this.instance_ptr, string, n);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_chmod(long var0, String var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fchmod(int n, int n2) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_fchmod(this.instance_ptr, n, n2);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_fchmod(long var0, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(String string, long l) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_truncate(this.instance_ptr, string, l);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_truncate(long var0, String var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int open(String string, int n, int n2) throws FileNotFoundException {
        this.rlock.lock();
        try {
            int n3 = CephMount.native_ceph_open(this.instance_ptr, string, n, n2);
            return n3;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_open(long var0, String var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int open(String string, int n, int n2, int n3, int n4, int n5, String string2) throws FileNotFoundException {
        this.rlock.lock();
        try {
            int n6 = CephMount.native_ceph_open_layout(this.instance_ptr, string, n, n2, n3, n4, n5, string2);
            return n6;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_open_layout(long var0, String var2, int var3, int var4, int var5, int var6, int var7, String var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int n) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_close(this.instance_ptr, n);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_close(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lseek(int n, long l, int n2) {
        this.rlock.lock();
        try {
            long l2 = CephMount.native_ceph_lseek(this.instance_ptr, n, l, n2);
            return l2;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native long native_ceph_lseek(long var0, int var2, long var3, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(int n, byte[] byArray, long l, long l2) {
        this.rlock.lock();
        try {
            long l3 = CephMount.native_ceph_read(this.instance_ptr, n, byArray, l, l2);
            return l3;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native long native_ceph_read(long var0, int var2, byte[] var3, long var4, long var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(int n, byte[] byArray, long l, long l2) {
        this.rlock.lock();
        try {
            long l3 = CephMount.native_ceph_write(this.instance_ptr, n, byArray, l, l2);
            return l3;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native long native_ceph_write(long var0, int var2, byte[] var3, long var4, long var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ftruncate(int n, long l) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_ftruncate(this.instance_ptr, n, l);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_ftruncate(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fsync(int n, boolean bl) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_fsync(this.instance_ptr, n, bl);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_fsync(long var0, int var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fstat(int n, CephStat cephStat) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_fstat(this.instance_ptr, n, cephStat);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_fstat(long var0, int var2, CephStat var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync_fs() {
        this.rlock.lock();
        try {
            CephMount.native_ceph_sync_fs(this.instance_ptr);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_sync_fs(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getxattr(String string, String string2, byte[] byArray) throws FileNotFoundException {
        this.rlock.lock();
        try {
            long l = CephMount.native_ceph_getxattr(this.instance_ptr, string, string2, byArray);
            return l;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native long native_ceph_getxattr(long var0, String var2, String var3, byte[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lgetxattr(String string, String string2, byte[] byArray) throws FileNotFoundException {
        this.rlock.lock();
        try {
            long l = CephMount.native_ceph_lgetxattr(this.instance_ptr, string, string2, byArray);
            return l;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native long native_ceph_lgetxattr(long var0, String var2, String var3, byte[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listxattr(String string) throws FileNotFoundException {
        this.rlock.lock();
        try {
            String[] stringArray = CephMount.native_ceph_listxattr(this.instance_ptr, string);
            return stringArray;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String[] native_ceph_listxattr(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] llistxattr(String string) throws FileNotFoundException {
        this.rlock.lock();
        try {
            String[] stringArray = CephMount.native_ceph_llistxattr(this.instance_ptr, string);
            return stringArray;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String[] native_ceph_llistxattr(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removexattr(String string, String string2) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_removexattr(this.instance_ptr, string, string2);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_removexattr(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lremovexattr(String string, String string2) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_lremovexattr(this.instance_ptr, string, string2);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_lremovexattr(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setxattr(String string, String string2, byte[] byArray, long l, int n) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_setxattr(this.instance_ptr, string, string2, byArray, l, n);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_setxattr(long var0, String var2, String var3, byte[] var4, long var5, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lsetxattr(String string, String string2, byte[] byArray, long l, int n) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_lsetxattr(this.instance_ptr, string, string2, byArray, l, n);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_lsetxattr(long var0, String var2, String var3, byte[] var4, long var5, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_file_stripe_unit(int n) {
        this.rlock.lock();
        try {
            int n2 = CephMount.native_ceph_get_file_stripe_unit(this.instance_ptr, n);
            return n2;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_get_file_stripe_unit(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_file_pool_name(int n) {
        this.rlock.lock();
        try {
            String string = CephMount.native_ceph_get_file_pool_name(this.instance_ptr, n);
            return string;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String native_ceph_get_file_pool_name(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_file_replication(int n) {
        this.rlock.lock();
        try {
            int n2 = CephMount.native_ceph_get_file_replication(this.instance_ptr, n);
            return n2;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_get_file_replication(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localize_reads(boolean bl) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_localize_reads(this.instance_ptr, bl);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_localize_reads(long var0, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_stripe_unit_granularity() {
        this.rlock.lock();
        try {
            int n = CephMount.native_ceph_get_stripe_unit_granularity(this.instance_ptr);
            return n;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_get_stripe_unit_granularity(long var0);

    public int get_pool_id(String string) throws CephPoolException {
        this.rlock.lock();
        try {
            int n = CephMount.native_ceph_get_pool_id(this.instance_ptr, string);
            return n;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CephPoolException("pool name " + string + " not found");
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_get_pool_id(long var0, String var2) throws FileNotFoundException;

    public int get_pool_replication(int n) throws CephPoolException {
        this.rlock.lock();
        try {
            int n2 = CephMount.native_ceph_get_pool_replication(this.instance_ptr, n);
            return n2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CephPoolException("pool id " + n + " not found");
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_get_pool_replication(long var0, int var2) throws FileNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CephFileExtent get_file_extent(int n, long l) {
        this.rlock.lock();
        try {
            CephFileExtent cephFileExtent = CephMount.native_ceph_get_file_extent_osds(this.instance_ptr, n, l);
            return cephFileExtent;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native CephFileExtent native_ceph_get_file_extent_osds(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket[] get_osd_crush_location(int n) {
        this.rlock.lock();
        try {
            String[] stringArray = CephMount.native_ceph_get_osd_crush_location(this.instance_ptr, n);
            Bucket[] bucketArray = new Bucket[stringArray.length / 2];
            for (int i = 0; i < bucketArray.length; ++i) {
                bucketArray[i] = new Bucket(stringArray[i * 2], stringArray[i * 2 + 1]);
            }
            Bucket[] bucketArray2 = bucketArray;
            return bucketArray2;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String[] native_ceph_get_osd_crush_location(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress get_osd_address(int n) {
        this.rlock.lock();
        try {
            InetAddress inetAddress = CephMount.native_ceph_get_osd_addr(this.instance_ptr, n);
            return inetAddress;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native InetAddress native_ceph_get_osd_addr(long var0, int var2);

    static {
        CephNativeLoader.checkLoaded();
    }
}

